import { useEffect, useState } from "react"
import ApiConnector from "../../Integrations/api.connector"
import { Row, Typography } from "antd"
import { IHome } from "../../Interfaces/home"

const Home = () => {
    const [home, setHome] = useState<IHome | null>(null)

    const getData = async () => {
        const data = await ApiConnector.getHome()
        setHome(data || null)
    }
    
    useEffect(() => {
        getData()
    }, [])

    return (
        <Row>
            <Row>
                <Typography.Title>
                    {home?.promo?.title}
                </Typography.Title>
            </Row>
            <Row>
                <Typography>
                    {home?.promo?.content}
                </Typography>
            </Row>
        </Row>
    )
}

export default Home