import {BrowserRouter, Routes, Route} from 'react-router-dom'
import Home from './containers/Home'
import Contacts from './containers/Contacts'
import {Provider} from 'react-redux'
import store from './store/store'

const App = () => {
    return (
        <Provider store={store}>
            <BrowserRouter>
                <Routes>
                    <Route path='/' element={<Home/>}/>
                    <Route path='/contacts' element={<Contacts/>}/>
                </Routes>
            </BrowserRouter>
        </Provider>
    )
}

export default App