import { useAppSelector, useAppDispatch } from "../store/hooks"
import { getHome, postHome } from "../store/slices/home/home.async"

const Home = () => {
    const dispatch = useAppDispatch()

    const home = useAppSelector(state => state.home)

    if(home.isLoad) return <div>Loading...</div>

    const getHandler = () => {
        dispatch(getHome())
    }

    const postHandler = () => {
        dispatch(postHome('POST ASYNC TEST'))
    }

    return (
        <div>
            <button onClick={postHandler}>POST</button>
            <button onClick={getHandler}>GET</button>
        </div>
    )
}

export default Home