import { createAsyncThunk } from "@reduxjs/toolkit";
import { axiosBase } from "../../../config/axiosBase";


export const getHome = createAsyncThunk(
    'home/getHome',
    async () => {
        const {data} = await axiosBase.get('home.json')
        return data
    }
)

export const postHome = createAsyncThunk(
    'home/postHome',
    async (text: string) => {
        const {data} = await axiosBase.post('home.json', {text})
        return data
    }
)