import { createSlice, PayloadAction } from '@reduxjs/toolkit'
import { getHome, postHome } from './home.async'

interface IState {
    homeTitle: string
    isLoad: boolean
}

const initialState: IState = {
    homeTitle: '',
    isLoad: false
}

export const homeSlice = createSlice({
    name: 'home',
    initialState,
    reducers: {
        changeTitle: (state, action: PayloadAction<string>) => {
            state.homeTitle = action.payload
        }
    },
    extraReducers(builder) {
        builder
            .addCase(getHome.pending, (state) => {
                state.isLoad = true
            })
            .addCase(getHome.rejected, (state) => {
                state.isLoad = false
            })
            .addCase(getHome.fulfilled, (state, action) => {
                console.log(action.payload)
                state.isLoad = false
            })


            // POST HOME

            .addCase(postHome.pending, (state) => {
                state.isLoad = true
            })
            .addCase(postHome.rejected, (state) => {
                state.isLoad = false
            })
            .addCase(postHome.fulfilled, (state, action) => {
                console.log(action.payload)
                state.isLoad = false
            })

    },
})


export const {changeTitle} = homeSlice.actions