import { configureStore } from '@reduxjs/toolkit'
import { contactSlice } from './slices/contact/contact.slice'
import { homeSlice } from './slices/home/home.slice'

const store = configureStore({
    reducer: {
        contact: contactSlice.reducer,
        home: homeSlice.reducer
    }
})

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
export default store;