import { shallowEqual } from 'react-redux';
import { Route, Routes } from 'react-router-dom';
import WrapperLayout from './components/layout/WrapperLayout';
import { ProtectedRoute } from './components/ui/routes/ProtectedRoute';
import Auth from './pages/auth/Auth';
import { useAppSelector } from './store/hooks';

function App() {
  const { user } = useAppSelector((state) => state.user, shallowEqual);

  return (
    <Routes>
      <Route
        path="/"
        element={
          <ProtectedRoute user={user}>
            <WrapperLayout />
          </ProtectedRoute>
        }
      ></Route>
      <Route path="/auth" element={<Auth />} />
    </Routes>
  );
}

export default App;
