import React from 'react';
import { Navigate } from 'react-router-dom';
import { IUser } from '../../../types/user';

type ProtectedRouteProps = {
  user: IUser | null;
  children: React.ReactNode;
};

export const ProtectedRoute = ({ user, children }: ProtectedRouteProps) => {
  if (!user) {
    return <Navigate to="/auth" replace />;
  }

  return children;
};
