import { createSlice } from '@reduxjs/toolkit';
import { IUser } from '../../types/user';

interface State {
  user: IUser | null;
  error: Error | null;
  loading: boolean;
}

const initialState: State = {
  user: null,
  error: null,
  loading: false,
};

const userSlice = createSlice({
  name: 'user',
  initialState,
  reducers: {},
});

export default userSlice.reducer;
