'use client'

import { Card, Row } from 'antd'
import React, { useState } from 'react'
import Image from 'next/image'
import styles from './ProductList.module.scss'
import { produtItems } from '@/lib/contstants'
import { useRouter } from 'next/navigation'

const ProductList = () => {
    const router = useRouter()

    const [products] = useState(produtItems)

    return (
        <Row className={styles.productList}>
            {
                products?.map(item => (
                    <Card
                        key={item.id}
                        hoverable
                        style={{ width: 300 }}
                        onClick={() => router.push(`/${item.id}`)}
                        cover={
                            <Image 
                                src={item.imgSrc} 
                                alt={item.name}
                                width={300}
                                height={220}
                            />
                        }
                    >
                        <Card.Meta title={item.name} description={`${item.price} KZT`}/>
                    </Card>
                ))
            }
        </Row>
    )
}

export default ProductList