'use client'

import React, { useState } from 'react'
import { Button, Layout, Menu } from 'antd'
import styles from './Layout.module.scss'
import { AppstoreAddOutlined, AppstoreOutlined, MenuFoldOutlined, MenuUnfoldOutlined } from '@ant-design/icons'
import { ItemType, MenuItemType } from 'antd/es/menu/interface'
import { useRouter } from 'next/navigation'

const {Header, Sider, Content} = Layout

const items: ItemType<MenuItemType>[] = [
    {
        key: '1',
        icon: <AppstoreOutlined />,
        label: 'Товары',
    },
    {
        key: '2',
        icon: <AppstoreAddOutlined />,
        label: 'Создать товары'
    }
]

const CustomeLayout = ({children}: Readonly<{children: React.ReactNode}>) => {
    const router = useRouter()

    const [collapsed, setCollapsed] = useState(false);

    return (
        <Layout className={styles.layout}>
            <Sider 
                collapsible
                trigger={null}
                collapsed={collapsed}
            >
                <div className="demo-logo-vertical" />
                <Menu
                    theme="dark"
                    mode="inline"
                    defaultSelectedKeys={['1']}
                    items={items}
                    onSelect={(info) => {
                        if(info.key === '1') {
                            router.push('/')
                        } else {
                            router.push('/addProduct')
                        }
                    }}
                />
            </Sider>

            <Layout>
                <Header className={styles.header}>
                    <Button
                        type='text'
                        icon={collapsed ? <MenuUnfoldOutlined /> : <MenuFoldOutlined />}
                        onClick={() => setCollapsed(!collapsed)}
                    />
                </Header>
                <Content className={styles.content}>
                    {children}
                </Content>
            </Layout>
        </Layout>
    )
}

export default CustomeLayout