import { Col, Row, Typography, Space } from 'antd'
import { FacebookOutlined, InstagramOutlined, TwitterOutlined, WhatsAppOutlined } from '@ant-design/icons'

const FooterStyles: React.CSSProperties = {
    padding: '100px 150px',
    backgroundColor: 'rgba(21, 4, 51, 1)'
}

const IconStyles: React.CSSProperties = {
    color: 'white', 
    fontSize: '30px',
    cursor: 'pointer'
}

const Footer = () => {
  return (
    <Row style={FooterStyles}>
        <Row style={{width: '100%', marginBottom: '60px'}} align={'top'} justify={'space-between'}>
            <Col>
                <Row>
                    <Typography.Title style={{fontSize: '24px', color: 'white', fontWeight: 900}}>
                        Lopper
                    </Typography.Title>
                </Row>
                <Row>
                    <Typography.Text style={{color: 'white', fontWeight: 400, fontSize: '16px'}}>
                        Eu augue ut lectus arcu bibendum at.
                    </Typography.Text>
                </Row>
            </Col>

            <Col>
                <Row>
                    <Typography.Title style={{fontSize: '13px', color: 'white', fontWeight: 800}}>
                        Follow us
                    </Typography.Title>
                </Row>
                <Row align={'middle'} justify={'space-between'}>
                    <Space>
                        <FacebookOutlined style={IconStyles}/>
                        <InstagramOutlined style={IconStyles}/>
                        <WhatsAppOutlined style={IconStyles}/>
                        <TwitterOutlined style={IconStyles}/>
                    </Space>
                </Row>
            </Col>
        </Row>

        <Row justify={'center'} align={'middle'} style={{width: '100%'}}>
            <Typography.Text style={{fontSize: '12px', color: 'rgba(252, 252, 252, 1)'}}>
                © 2019 Lopper by mariuszdaniel. All right reserved.
            </Typography.Text>
        </Row>
    </Row>
  )
}

export default Footer