import { Card, Row, Typography, Image } from 'antd'
import ItemIcon from '../../../assets/Icon.png'

type TProps = {
    titleText: string
    contentText: string
    textColor?: string
}

const ItemStyles: React.CSSProperties = {
    width: '30%',
    background: 'none'
}

const Item = ({titleText, contentText, textColor}: TProps) => {
  return (
    <Card style={ItemStyles}>
        <Row>
            <Image
                width={75}
                src={ItemIcon}
            />
        </Row>

        <Row>
            <Typography.Title style={{fontSize: '27px', fontWeight: 500, color: textColor || 'rgba(48, 35, 61, 1)'}}>
                {titleText}
            </Typography.Title>
        </Row>

        <Row>
            <Typography.Text style={{fontSize: '16px', fontWeight: 400, color: textColor || 'rgba(48, 35, 61, 1)'}}>
                {contentText}
            </Typography.Text>
        </Row>
    </Card>
  )
}

export default Item