
import { Row, Typography } from 'antd'
import Item from './Item/Item'

const content = 'Eget nulla facilisi etiam dignissim diam quis enim lobortis scelerisque. Eu feugiat pretium nibh ipsum consequat nisl vel pretium.'

const items = [
    {
        title: 'Research',
        content
    },
    {
        title: 'Marketing',
        content
    },
    {
        title: 'Results',
        content
    }
]

const PromoStyles: React.CSSProperties = {
    padding: '100px 150px'
}

const PromoTitle: React.CSSProperties = {
    fontSize: '15px', 
    color: 'rgba(246, 16, 103, 1)', 
    fontWeight: '800'
}

const PromoText: React.CSSProperties = {
    fontSize: '27px', 
}

type TProps = {
    bgColor?: string
    textColor?: string
}

const Promo = ({bgColor, textColor}: TProps) => {
    return (
        <Row style={{...PromoStyles, backgroundColor: bgColor || 'white'}}>
            <Row style={{width: '100%'}}>
                <Typography.Title style={PromoTitle}>
                    What we do
                </Typography.Title>
            </Row>

            <Row style={{width: '100%'}}>
                <Typography.Paragraph style={{...PromoText, color: textColor || 'rgba(48, 35, 61, 1)'}}>
                    Apparently we had reached a great height in the atmosphere, for the sky was a dead black, and the stars had ceased to twinkle.
                </Typography.Paragraph>
            </Row>

            <Row align={'middle'} justify={'space-between'} style={{width: '100%'}}>
                {
                    items.map(item => (
                        <Item 
                            key={item.title} 
                            titleText={item.title} 
                            contentText={item.content}
                            textColor={textColor}
                        />
                    ))
                }
            </Row>
        </Row>
    )
}

export default Promo