Контрольная работа #7

Задание: Реализовать REST API для управления библиотекой компании

## Технические требования:
- **СУБД**: PostgreSQL
- **ORM**: Dapper
- **Архитектура**: Разделение проекта на слои:
  - Controllers (для обработки HTTP-запросов)
  - Services (для реализации бизнес-логики)
  - Repositories (для взаимодействия с базой данных через Dapper)
- **Exception Handling**: Реализовать Global Exception Handler через Middleware. Все исключения должны быть централизованно обработаны и возвращать стандартизированные ответы.
- **Валидация**: Использовать FluentValidation для валидации входящих данных.
- **Port**: 5000

#### ***Бонус +1 балл***
- **Data Seeding**: Обеспечить первоначальное заполнение базы данных (Data Seeding) для удобства проверки работы API.

#### ***Бонус +1 балл***
- **Тестирование**: Добавить unit тесты для каждого метода API.
---
### Изменение API запрещено!
### Этап 1: API для книг

#### Создание книги
- **POST** `/api/books`

Request:
```json
{
  "title": "Название книги",
  "author": "Автор книги",
  "coverImageUrl": "URL изображения",
  "publicationYear": 2020,
  "description": "Описание книги"
}
```

Response:
```json
{
  "id": 1,
  "title": "Название книги",
  "author": "Автор книги",
  "coverImageUrl": "URL изображения",
  "publicationYear": 2020,
  "description": "Описание книги",
  "status": "available",
  "createdAt": "2025-03-07T10:30:00Z"
}
```

#### Получение списка книг с постраничной навигацией
- **GET** `/api/books?page=1&pageSize=8`

Response:
```json
{
  "page": 1,
  "totalPages": 5,
  "books": [
    {
      "id": 1,
      "title": "Название книги",
      "author": "Автор книги",
      "coverImageUrl": "URL изображения",
      "status": "available",
      "createdAt": "2025-03-07T10:30:00Z"
    }
  ]
}
```

#### Получение детальной информации по книге
- **GET** `/api/books/{id}`

Response:
```json
{
  "id": 1,
  "title": "Название книги",
  "author": "Автор книги",
  "coverImageUrl": "URL изображения",
  "publicationYear": 2020,
  "description": "Описание книги",
  "status": "available",
  "createdAt": "2025-03-07T10:30:00Z"
}
```

#### Обновление информации о книге
- **PUT** `/api/books/{id}`

Request:
```json
{
  "title": "Новое название книги",
  "author": "Новый автор",
  "coverImageUrl": "Новый URL изображения",
  "publicationYear": 2021,
  "description": "Новое описание книги"
}
```

Response:
```json
{
  "message": "Книга успешно обновлена"
}
```

#### Удаление книги
- **DELETE** `/api/books/{id}`

Response:
```json
{
  "message": "Книга успешно удалена"
}
```

### Этап 2: Регистрация пользователей и выдача книг

#### Регистрация пользователя
- **POST** `/api/users`

Request:
```json
{
  "firstName": "Имя",
  "lastName": "Фамилия",
  "email": "user@example.com",
  "phoneNumber": "+1234567890"
}
```

Response:
```json
{
  "id": 1,
  "firstName": "Имя",
  "lastName": "Фамилия",
  "email": "user@example.com",
  "phoneNumber": "+1234567890"
}
```

#### Выдача книги пользователю
- **POST** `/api/books/{id}/borrow`

Request:
```json
{
  "email": "user@example.com"
}
```

Response:
```json
{
  "message": "Книга успешно выдана"
}
```

#### Просмотр списка всех выданных книг
- **GET** `/api/books/borrowed`

Response:
```json
[
  {
    "bookId": 1,
    "title": "Название книги",
    "borrowedBy": "user@example.com",
    "borrowedAt": "2025-03-08T10:00:00Z"
  }
]
```

### Этап 3: Личный кабинет и возврат книг

#### Просмотр книг пользователя
- **GET** `/api/users/{email}/books`

Response:
```json
[
  {
    "id": 1,
    "title": "Название книги",
    "author": "Автор книги",
    "borrowedAt": "2025-03-08T10:00:00Z"
  }
]
```

#### Возврат книги
- **POST** `/api/books/{id}/return`

Request:
```json
{
  "email": "user@example.com"
}
```

Response:
```json
{
  "message": "Книга успешно возвращена"
}
```

#### Бонус +2 балла - Загрузка и скачивание книг в формате PDF

Загрузка:
- **POST** `/api/books/{id}/upload`

Скачивание:
- **GET** `/api/books/{id}/download`

Response:
- PDF файл книги
