import { Grid2, TextField, Typography } from '@mui/material';
import { ChangeEvent } from 'react';

interface Props {
   name: 'Decoded' | 'Encoded' | 'Password';
   value: string;
   onChange: (e: ChangeEvent<HTMLInputElement>) => void;
}

export default function InputField({ name, value, onChange }: Props) {
   let labelText: string = '';
   switch (name) {
      case 'Decoded':
         labelText = `Decoded message`;
         break;
      case 'Encoded':
         labelText = `Encoded message`;
         break;
      case 'Password':
         labelText = '';
         break;
      default:
         break;
   }

   return (
      <Grid2 container alignItems="center" paddingY={2} spacing={2}>
         <Grid2 flexGrow={1}>
            <Typography
               component="label"
               htmlFor={`${name}-input`}
               sx={{
                  fontSize: {
                     xs: '16px',
                     sm: '20px',
                  },
               }}
            >
               {labelText}
            </Typography>
         </Grid2>

         <Grid2 size={name === 'Password' ? 6 : 8} sx={{ '@media (max-width: 900px)': { width: '100%' } }}>
            <TextField
               fullWidth
               multiline={name !== 'Password'}
               rows={name === 'Password' ? 1 : 6}
               variant="outlined"
               id={`${name}-input`}
               name={name}
               value={value}
               type="password"
               onChange={onChange}
            />
         </Grid2>
      </Grid2>
   );
}
