import { NestFactory } from '@nestjs/core';
import { ConfigModule } from '@nestjs/config';
import { MessageModule } from './message/message.module';

ConfigModule.forRoot();

async function startServer() {
  const app = await NestFactory.create(MessageModule);
  app.enableCors({
    origin: 'http://localhost:666',
    methods: 'GET,POST,PUT,DELETE',
    allowedHeaders: 'Content-Type,Authorization',
    credentials: true,
  });
  await app.listen(8000);
}
startServer();
