import { Controller, Post, Body } from '@nestjs/common';
import { MessageService } from './message.service';
import { CreateMessageDto } from './dto/create-message.dto';

@Controller()
export class MessageController {
  constructor(private readonly messageService: MessageService) {}

  @Post('/encode')
  encodeMessage(@Body() createMessageDto: CreateMessageDto): {
    encoded: string;
  } {
    const { password, message } = createMessageDto;
    const encoded = this.messageService.encodeMessage(password, message);
    return { encoded };
  }

  @Post('/decode')
  decodeMessage(@Body() createMessageDto: CreateMessageDto): {
    decoded: string;
  } {
    const { password, message } = createMessageDto;
    const decoded = this.messageService.decodeMessage(password, message);
    return { decoded };
  }
}
