import { Injectable } from '@nestjs/common';
import { Vigenere } from 'caesar-salad';

@Injectable()
export class MessageService {
  encodeMessage(password: string, message: string): string {
    return Vigenere.Cipher(password.trim()).crypt(message);
  }

  decodeMessage(password: string, message: string): string {
    return Vigenere.Decipher(password.trim()).crypt(message);
  }
}
