using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Store.Models;

namespace Store.Controllers
{
    public class ProductController : Controller
    {
        private ProductContext _context;

        public ProductController(ProductContext context)
        {
            _context = context;
        }

        public IActionResult Index()
        {
            return View(_context.Products);
        }

        public IActionResult Details(string id)
        {
            Product product = _context.Products
                .Include(p => p.Supplier)
                .First(p => p.Id.ToString() == id);

            ViewBag.product = product;
            ViewBag.supplier = product.Supplier;
            return View();
        }

        [HttpGet]
        public IActionResult Create()
        {
            List<Supplier> suppliers = _context.Suppliers.ToList();
            ViewBag.suppliers = suppliers;
            return View(new Product());
        }

        [HttpPost]
        public IActionResult Create(Product product)
        {
            _context.Products.Add(product);
            _context.SaveChanges();
            return View("Details", product);
        }
    }
}
