using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Store.Models;

namespace Store.Controllers
{
    public class ProductController : Controller
    {
        private ProductContext _context;

        public ProductController(ProductContext context)
        {
            _context = context;
        }

        public IActionResult Index()
        {
            return View(_context.Products);
        }

        public IActionResult Details(string id)
        {
            Product product = _context.Products.FirstOrDefault(p => p.Id == id);
            ViewBag.product = product;
            return View();
        }

        [ActionName("CreateProduct")]
        [HttpGet]
        public IActionResult Create()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Create(Product product)
        {
            _context.Products.Add(product);
            _context.SaveChanges();
            return View("Details", product);
        }
    }
}
