using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Store.Models;

namespace Store.Controllers
{
    public class ProductController : Controller
    {
        public IActionResult Index()
        {
            List<Product> products = new List<Product>
            {
                new Product
                {
                    Id = Guid.NewGuid().ToString(),
                    Name = "Asus A234",
                    Amount = 100,
                    Brand = "Asus",
                    Category = "TV"
                },
                new Product
                {
                    Id = Guid.NewGuid().ToString(),
                    Name = "Asus A674",
                    Amount = 150,
                    Brand = "Asus",
                    Category = "TV"
                }
            };

            ViewBag.products = products;

            return View();
        }

        public IActionResult Details(string id)
        {
            return View(new Product
            {
                Id = Guid.NewGuid().ToString(),
                Name = "Asus A674",
                Amount = 150,
                Brand = "Asus",
                Category = "TV"
            });
        }

        [HttpGet]
        public IActionResult Create()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Create(Product product)
        {

            return View("Details", product);
        }
    }
}
