import { Ingredients } from "@/interfaces/burger-interface";
import "./Burger.css";
import { Ingredient } from "@/components/Burger/Ingredient/Ingredient";
import { ReactNode } from "react";

interface Props {
  ingredients: Ingredients;
}

export function Burger({ ingredients }: Props) {
  const ingredientsKeys = Object.keys(ingredients) as (keyof Ingredients)[];

  let ingrList: ReactNode[] = [];

  ingredientsKeys.forEach((ingrKey) => {
    let amount = ingredients[ingrKey];

    for (let i = 0; i < amount; i++) {
      ingrList.push(<Ingredient key={ingrKey + i} type={ingrKey} />);
    }
  });

  return (
    <div className="Burger">
      <Ingredient type={"bread-top"} />
      {ingrList}
      <Ingredient type={"bread-bottom"} />
    </div>
  );
}
