import { IngredientNames } from "@/interfaces/burger-interface";
import "./Ingredient.css";

interface Props {
  type: IngredientNames | "bread-top" | "bread-bottom";
}

export function Ingredient({ type }: Props) {
  switch (type) {
    case "bread-bottom":
      return <div className="BreadBottom"></div>;
    case "bread-top":
      return (
        <div className="BreadTop">
          <div className="Seeds1"></div>
          <div className="Seeds2"></div>
        </div>
      );
    case "meat":
      return <div className="Meat"></div>;
    case "cheese":
      return <div className="Cheese"></div>;
    case "salad":
      return <div className="Salad"></div>;
    case "bacon":
      return <div className="Bacon"></div>;
    default:
      break;
  }
}
