import { IngredientNames, Ingredients } from "@/interfaces/burger-interface";

interface Props {
  ingredients: Ingredients;
  price: number;
}

export function OrderSummary({ ingredients, price }: Props) {
  const ingredientSummary = Object.keys(ingredients).map((igKey) => {
    return (
      <li key={igKey}>
        <span style={{ textTransform: "capitalize" }}>{igKey}</span>:{" "}
        {ingredients[igKey as IngredientNames]}
      </li>
    );
  });

  return (
    <>
      <h3>Your order</h3>
      <p>A delicious burger with the following ingredients:</p>
      <ul>{ingredientSummary}</ul>
      <p>
        <strong>Total Price: {price} ₸</strong>
      </p>
      <p>Continue to checkout?</p>
    </>
  );
}
