import { Dispatch, ReactNode, SetStateAction } from "react";
import { Backdrop } from "@/components/UI/Backdrop/Backdrop";
import "./Modal.css";

interface Props {
  isOpen: boolean;
  children: ReactNode;
  setIsOpen: Dispatch<SetStateAction<boolean>>;
}

export const Modal = ({ isOpen, children, setIsOpen }: Props) => {
  //   return isOpen ? (
  //     <>
  //       <Backdrop setIsOpen={setIsOpen} />
  //       <div className="Modal">{children}</div>
  //     </>
  //   ) : null;

  return (
    <div style={{ display: isOpen ? "block" : "none" }}>
      <Backdrop setIsOpen={setIsOpen} />
      <div className="Modal">{children}</div>
    </div>
  );
};
