import { BuildControls } from "@/components/BuildControls/BuildControls";
import { Burger } from "@/components/Burger/Burger";
import { OrderSummary } from "@/components/Burger/OrderSummary/OrderSummary";
import { Modal } from "@/components/UI/Modal/Modal";
import { IngredientNames, IngredientPrices, Ingredients } from "@/interfaces/burger-interface";
import { useState } from "react";

export function BurgerBuilder() {
  const [isOpen, setIsOpen] = useState<boolean>(false);
  const [purchasable, setPurchasable] = useState(false);
  const [totalPrice, setTotalPrice] = useState<number>(IngredientPrices.cheese);
  const [ingredients, setIngredients] = useState<Ingredients>({
    salad: 0,
    cheese: 0,
    bacon: 0,
    meat: 0,
  });

  const updatePurchasable = (newIngredients: Ingredients) => {
    const values = Object.values(newIngredients).reduce((acc, el) => acc + el, 0);

    setPurchasable(!!values);
  };

  const handleLess = (ingKey: IngredientNames) => {
    const newIngredients = {
      ...ingredients,
      [ingKey]: ingredients[ingKey] !== 0 ? ingredients[ingKey] - 1 : 0,
    };
    setIngredients(newIngredients);
    updatePurchasable(newIngredients);
  };

  const handleMore = (ingKey: IngredientNames) => {
    const newIngredients = {
      ...ingredients,
      [ingKey]: ingredients[ingKey] + 1,
    };
    setIngredients(newIngredients);
    updatePurchasable(newIngredients);
  };
  return (
    <>
      <Burger ingredients={ingredients} />
      <BuildControls
        ingredients={ingredients}
        totalPrice={totalPrice}
        purchasable={purchasable}
        handleLess={handleLess}
        handleMore={handleMore}
        setIsOpen={setIsOpen}
      />

      <Modal isOpen={isOpen} setIsOpen={setIsOpen}>
        <OrderSummary ingredients={ingredients} price={totalPrice} />
      </Modal>
    </>
  );
}
