﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Net.Mime;
using System.Reflection;
using System.Drawing;
using System.Drawing.Imaging;
using System.Threading;
using System.Web;
using RazorEngine;
using RazorEngine.Templating;
using Encoding = System.Text.Encoding;

namespace MyHttpServer
{
    public class DumbHttpServer
    {
        private Thread _thread;
        private string _siteDir;
        private HttpListener _listener;
        private int _port;
        private readonly List<Cat> _cats = GetCats();

        public DumbHttpServer(string path, int port)
        {
            Initialize(path, port);
        }

        private void Initialize(string path, int port)
        {
            _siteDir = path;
            _port = port;
            _thread = new Thread(Listen);
            _thread.Start();
            Console.WriteLine($"Сервер запущен на порту {_port}");
            Console.WriteLine($"Файлы сайта лежат в каталоге {_siteDir}");
        }

        private void Listen()
        {
            _listener = new HttpListener();
            _listener.Prefixes.Add($"http://localhost:{_port}/");
            _listener.Start();
            while (true)
            {
                try
                {
                    HttpListenerContext context = _listener.GetContext();
                    Process(context);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    break;
                }
            }
            Stop();
        }

        private void Process(HttpListenerContext context)
        {
            string fileName = context.Request.Url.AbsolutePath;
            Console.WriteLine(fileName);
            fileName = fileName.Substring(1);
            fileName = Path.Combine(_siteDir, fileName);
            string content = "";
            Stream fileStream;
            byte[] htmlBytes;
            if (context.Request.HttpMethod == "POST" && context.Request.Url.ToString().Contains("Add"))
            {
                Stream body = context.Request.InputStream;
                StreamReader reader = new StreamReader(body, Encoding.UTF8);
                string query = reader.ReadToEnd();
                if (query.Contains("%"))
                    query = HttpUtility.UrlDecode(query, Encoding.UTF8);
                string[] subquery = query.Split("&");
                string name = subquery[0].Substring(subquery[0].IndexOf("=") + 1);
                
                int age = Convert.ToInt32(subquery[1].Substring(subquery[0].IndexOf("=") + 1));
                _cats.Add(new Cat(name, age));
                HttpListenerResponse response = context.Response;
                
                reader.Close();
                body.Close();
                response.Redirect("http://localhost:7777/cats.html");
                response.Close();
            }
            else
            {
                if (File.Exists(fileName))
                {
                    try
                    {
                        if (fileName.Contains(".html"))
                        {
                            content = BuildHtml(fileName);
                            htmlBytes = Encoding.UTF8.GetBytes(content);
                        }
                        else
                        {
                            htmlBytes = File.ReadAllBytes(fileName);
                        }
                    
                        fileStream = new MemoryStream(htmlBytes);
                        context.Response.ContentType = GetContentType(fileName);
                        context.Response.ContentLength64 = fileStream.Length;
                        byte[] buffer = new byte[16 * 1024];
                        int dataLength;
                        do
                        {
                            dataLength = fileStream.Read(buffer, 0, buffer.Length);
                            context.Response.OutputStream.Write(buffer, 0, dataLength);
                        } while (dataLength > 0);
                        fileStream.Close();
                        context.Response.StatusCode = (int) HttpStatusCode.OK;
                        context.Response.OutputStream.Flush();
                    }
                    catch (Exception e)
                    {
                        Console.WriteLine(e.Message);
                        context.Response.StatusCode = (int) HttpStatusCode.InternalServerError;
                    }
                }
                else
                {
                    context.Response.StatusCode = (int) HttpStatusCode.NotFound;
                }
                context.Response.OutputStream.Close();
            }
            
            
        }

        private static List<Cat> GetCats()
        {
            List<Cat> cats = new List<Cat>();
                cats.Add(new Cat("Tom", 10));
                cats.Add(new Cat("Tom", 10));
                cats.Add(new Cat("Tom", 10));
                cats.Add(new Cat("Tom", 10));
                cats.Add(new Cat("Tom", 10));
                cats.Add(new Cat("Tom", 10));
                cats.Add(new Cat("Jerry", 2));
                cats.Add(new Cat("Simon", 2));
                return cats;
        }

        private string BuildHtml(string fileName)
        {
            string html = "";
            string layoutPath = Path.Combine(_siteDir, "layout.html");
            string filePath = Path.Combine(_siteDir, fileName);

            var razorService = Engine.Razor;
            if (!razorService.IsTemplateCached("layout", null))
                razorService.AddTemplate("layout", File.ReadAllText(layoutPath));
            if (!razorService.IsTemplateCached(fileName, null))
            {
                razorService.AddTemplate(fileName, File.ReadAllText(filePath));
                razorService.Compile(fileName);
            }
            
            html = razorService.Run(fileName, null, new
            {
                indexTitle = "Заголовок главной страницы",
                page1 = "Первая страница",
                page2 = "Вторая страница",
                cats = _cats
            });
            return html;

        }


        private string GetContentType(string fileName)
        {
             var dictionary = new Dictionary<string, string> {
                        {".css",  "text/css"},
                        {".html", "text/html"},
                        {".ico",  "image/x-icon"},
                        {".js",   "application/x-javascript"},
                        {".json", "application/json"},
                        {".png",  "image/png"}
                    };
             string contentType = "";
             string fileExtension = Path.GetExtension(fileName);
             dictionary.TryGetValue(fileExtension, out contentType);
             return contentType;
        }

        public void Stop()
        {
            _thread.Abort();
            _listener.Stop();
        }
    }
}