using System.Collections.Generic;
using System.Linq;
using PhoneStore.Models;
using PhoneStore.Services.Interfaces;

namespace PhoneStore.Services;

public class SearchService : ISearchService
{
    private readonly IUserSearchService _userSearch;

    public SearchService(IUserSearchService userSearch)
    {
        _userSearch = userSearch;
    }
    public IEnumerable<User> SearchUsersByAny(string searchTerm)
    {
        var resultByName = _userSearch.SearchByName(searchTerm);
        var resultByLogin = _userSearch.SearchByLogin(searchTerm);
        var resultByEmail = _userSearch.SearchByEmail(searchTerm);
        var users = resultByName
            .Concat(resultByLogin)
            .Concat(resultByEmail)
            .ToHashSet();

        //if (users == null || !users.Any())
        if (users?.Any() ?? false)
        {
            return users;
        }
            
        return new List<User>();
    }
}