using System.ComponentModel.DataAnnotations;

namespace PhoneStore.ViewModels.Account
{
    public class LoginViewModel
    {
        private const string  RequiredErrorMessage = "Поле обязательно для заполнения";
        [Required(ErrorMessage = RequiredErrorMessage)]
        [Display(Name = "Email")]
        public string Email { get; set; }
   
        [Required(ErrorMessage = RequiredErrorMessage)]
        [DataType(DataType.Password)]
        [Display(Name = "Пароль")]
        public string Password { get; set; }
   
        [Display(Name = "Запомнить?")]
        public bool RememberMe { get; set; }
   
        public string ReturnUrl { get; set; }
    }
}