using Payment.WebApi.Infrastructures.Databases;
using Payment.WebApi.Models.DbModels;
using Payment.WebApi.Repositories.Interfaces;

namespace Payment.WebApi.Repositories;

public class SupplierRepository : ISupplierRepository
{
    private readonly PaymentDbContext _context;

    public SupplierRepository(PaymentDbContext context)
    {
        _context = context ?? throw new ArgumentNullException(nameof(context));
    }

    public List<Supplier> GetAll()
    {
        var suppliers = _context.Suppliers.ToList();
        return suppliers;
    }

    public void Create(Supplier item)
    {
        _context.Suppliers.Add(item);
    }

    public void Update(Supplier item)
    {
        _context.Suppliers.Update(item);
    }

    public void Remove(Supplier item)
    {
        _context.Suppliers.Remove(item);
    }

    public void Save()
    {
        _context.SaveChanges();
    }
}