using Payment.WebApi.Infrastructures.Databases;
using Payment.WebApi.Models.DbModels;
using Payment.WebApi.Repositories.Interfaces;

namespace Payment.WebApi.Repositories;

public class UserRepository : IUserRepository
{
    private readonly PaymentDbContext _context;

    public UserRepository(PaymentDbContext context) =>
        _context = context ?? throw new ArgumentNullException(nameof(context));

    public User? GetFirstOrDefaultById(int id) => _context.Users.FirstOrDefault(s => s.Id == id);
    public void Create(User item) => _context.Users.Add(item);
    public void Update(User item) => _context.Users.Update(item);
    public void Remove(User item) => _context.Users.Remove(item);
    public void Save() => _context.SaveChanges();
}