using Microsoft.AspNetCore.Mvc;
using Payment.WebApi.Models.DbModels;
using Payment.WebApi.Repositories.Interfaces;

namespace Payment.WebApi.Controllers;

[ApiController]
public class UserController : Controller
{
    private readonly IUserRepository _userRepository;

    public UserController(IUserRepository userRepository)
    {
        _userRepository = userRepository;
    }

    public ActionResult<User> GetUser(int id)
    {
        try
        {
            var user = _userRepository.GetFirstOrDefaultById(id);
            if (user is null)
                return NotFound();

            return Ok(user);
        }
        catch (Exception e)
        {
            return StatusCode(500, new { errorMessage = e.Message });
        }
    }
}