using Microsoft.EntityFrameworkCore;
using Payment.WebApi.Models.DbModels;

namespace Payment.WebApi.Infrastructures.Databases;

public static class DataSeeder
{
    public static void SeedUser(this ModelBuilder builder)
    {
        builder.Entity<User>()
            .HasData(new User
            {
                Id = 1,
                Age = 25,
                FirstName = "Jhon",
                LastName = "Doe",
                MiddleName = "Blastovich"
            });
        
        builder.Entity<User>()
            .HasData(new User
            {
                Id = 2,
                Age = 27,
                FirstName = "Jhoan",
                LastName = "Shepard",
                MiddleName = default
            });
    }

    public static void SeedUserBalance(this ModelBuilder builder)
    {
        builder.Entity<UserBalance>()
            .HasData(new List<UserBalance>
            {
                new UserBalance
                {
                    Id = 1,
                    Amount = 100,
                    Currency = "KZT",
                    UserId = 1
                },
                new UserBalance
                {
                    Id = 2,
                    Amount = 250,
                    Currency = "KZT",
                    UserId = 2
                }
            });
    }

    public static void SeedSupplier(this ModelBuilder builder)
    {
        builder.Entity<Supplier>()
            .HasData(new List<Supplier>
            {
                new Supplier
                {
                    Id = 1,
                    Name = "Алсеко"
                },
                new Supplier
                {
                    Id = 2,
                    Name = "Казактелеком"
                },
                new Supplier
                {
                    Id = 3,
                    Name = "Beeline"
                }
            });
    }
}