using Microsoft.AspNetCore.Mvc;
using Payment.WebApi.Models.DbModels;
using Payment.WebApi.Repositories.Interfaces;

namespace Payment.WebApi.Controllers;

[ApiController]
public class SupplierController : Controller
{
    private readonly ISupplierRepository _supplierRepository;

    public SupplierController(ISupplierRepository supplierRepository)
    {
        _supplierRepository = supplierRepository;
    }

    public ActionResult<List<Supplier>> GetAll()
    {
        try
        {
            return Ok(_supplierRepository.GetAll());
        }
        catch (Exception e)
        {
            return StatusCode(500, new { errorMessage = e.Message });
        }
    }
}