using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Payment.WebApi.Models.DbModels;

namespace Payment.WebApi.Infrastructures.Databases.MapConfigurations;

public class UserDbMap : IEntityTypeConfiguration<User>
{
    public void Configure(EntityTypeBuilder<User> builder)
    {
        builder.HasKey(opt => opt.Id);
        builder.Property(opt => opt.FirstName).HasColumnType("VARCHAR(256)").IsRequired();
        builder.Property(opt => opt.LastName).HasColumnType("VARCHAR(256)");
        builder.Property(opt => opt.MiddleName).HasColumnType("VARCHAR(256)");
        builder.Property(opt => opt.Email).HasMaxLength(128).IsRequired();
        builder.Property(opt => opt.Age).HasColumnType("SMALLINT");
    }
}