using FluentValidation;
using Payment.WebApi.Models.RequestModels;
using Payment.WebApi.Models.RequestModels.Users;

namespace Payment.WebApi.Validators;

public class UserRequestModelValidator : AbstractValidator<UserCreateRequestModel>
{
    public UserRequestModelValidator()
    {
        RuleFor(s => s.FirstName).NotEmpty().WithMessage("Имя обязательно для заполнения");
        RuleFor(s => s.Email).NotEmpty().WithMessage("Email обязателен для заполнения");
        RuleFor(s => s.Age).GreaterThan(0).WithMessage("Возраст не должен быть меньше либо равен нулю");
    }
}