using Microsoft.EntityFrameworkCore;
using Payment.WebApi.Infrastructures.Databases;
using Payment.WebApi.Repositories;
using Payment.WebApi.Repositories.Interfaces;

namespace Payment.WebApi.Extensions;

public static class AppServicesExtension
{
    public static void AddAppServices(this IServiceCollection services, IConfiguration configuration)
    {
        services.AddDbContext<PaymentDbContext>(opt
            => opt.UseNpgsql(configuration.GetConnectionString("ConnectionString")));
        services.AddScoped<IUserRepository, UserRepository>();
        services.AddScoped<ISupplierRepository, SupplierRepository>();
    }
}