using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Payment.WebApi.Models.DbModels;

namespace Payment.WebApi.Infrastructures.Databases.MapConfigurations;

public class UserBalanceDbMap : IEntityTypeConfiguration<UserBalance>
{
    public void Configure(EntityTypeBuilder<UserBalance> builder)
    {
        builder.HasKey(opt => opt.Id);
        builder.Property(opt => opt.Currency).HasMaxLength(8).IsRequired();
        builder.Property(opt => opt.Amount).HasColumnType("NUMERIC(18,2)");
    }
}