using Microsoft.EntityFrameworkCore;
using Payment.WebApi.Infrastructures.Databases.MapConfigurations;
using Payment.WebApi.Models.DbModels;

namespace Payment.WebApi.Infrastructures.Databases;

public class PaymentDbContext : DbContext
{
    public DbSet<User> Users { get; set; }
    public DbSet<Supplier> Suppliers { get; set; }
    
    public PaymentDbContext(DbContextOptions<PaymentDbContext> options) : base(options)
    {
    }

    protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
    {
        optionsBuilder.UseLazyLoadingProxies();
    }

    protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        base.OnModelCreating(modelBuilder);
        
        modelBuilder.SeedUser();
        modelBuilder.SeedSupplier();
        modelBuilder.SeedUserBalance();

        modelBuilder.ApplyConfiguration(new UserDbMap());
        modelBuilder.ApplyConfiguration(new UserBalanceDbMap());
    }
}